////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

const char *NULLSTR = "NULL";
const int NULLSTRLEN = 4;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void WriteNull(FILE *TargetHandle)
{
    fwrite(&NULLSTRLEN, sizeof(NULLSTRLEN), 1, TargetHandle);
    fwrite(NULLSTR, sizeof(char), NULLSTRLEN, TargetHandle);
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

SQLINTEGER CharTrim(SQLCHAR *Data, SQLINTEGER Length)
{
    SQLINTEGER Pos = Length;

    if(Length == 0)
        return Length;

    if(Data[Length-1] != ' ')
        return Length;

    Pos--;

    while(Pos != 0 && Data[Pos] == ' ')
        Pos--;

    if(Data[Pos] != ' ')
        Pos++;

    Data[Pos] = '\0';

    return Pos;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool ExportSQLResults(char *Driver, char *Server, char *UID, char *PWD, char *Database, char *Statement, char *ImportTable, char *OutFileName)
{
    SQLBasics SQL;
    HSTMT StatementHandle;

    if(!SQL.DBConnect(Driver, Server, UID, PWD, Database))
    {
        printf("DBConnect: Fail.\n");
        return false;
    }

    if(!SQL.DBExecute(Statement, &StatementHandle))
    {
        SQL.DBDisconnect();
        printf("DBexecute: Fail.\n");
        return false;
    }

    FILE *TargetHandle = NULL;

    if((TargetHandle = fopen(OutFileName, "wb")) == NULL)
    {
        SQL.DBCloseCursor(&StatementHandle);
        SQL.DBDisconnect();
        printf("TargetFile: Error.\n");
        return false;
    }

    SQLSMALLINT outColumnCount = 0;
    if(SQLNumResultCols(StatementHandle, &outColumnCount) != SQL_SUCCESS)
    {
        SQL.DBCloseCursor(&StatementHandle);
        SQL.DBDisconnect();
        if(TargetHandle) fclose(TargetHandle);
        printf("SQLNumResultCols: Error.\n");
        return false;
    }

    SQLINTEGER outRowCount = 0;
    if(SQLRowCount(StatementHandle, &outRowCount) != SQL_SUCCESS)
    {
        SQL.DBCloseCursor(&StatementHandle);
        SQL.DBDisconnect();
        if(TargetHandle) fclose(TargetHandle);
        printf("SQLRowCount: Error.\n");
        return false;
    }

    int ImportTableNameLen = strlen(ImportTable);
    fwrite(&ImportTableNameLen, sizeof(ImportTableNameLen), 1, TargetHandle); // Write import table name len
    fwrite(ImportTable, sizeof(char), ImportTableNameLen, TargetHandle); // Write import table name
    fwrite(&outColumnCount, sizeof(outColumnCount), 1, TargetHandle); // Write number of columbs
    fwrite(&outRowCount, sizeof(outRowCount), 1, TargetHandle);       // Write number of rows

    //---------------( Get Columb Information )---
    SQLSMALLINT inColumnNameLen = 256;

	SQLUINTEGER outColumnSizePtr = 0;

    SQLSMALLINT outColumnNameLen = 0;
    SQLSMALLINT *outDataType = 0;
    SQLSMALLINT outDecimalDigitsPtr = 0;
    SQLSMALLINT outNullablePtr = 0;

    SQLCHAR outColumnName[256];

    SQLRETURN SQLResult = 0;

    int ColumbLoop = 0;

    outDataType = (SQLSMALLINT *) calloc( sizeof(SQLSMALLINT), outColumnCount);

    do{
        SQLResult = SQLDescribeCol(StatementHandle, ColumbLoop + 1, outColumnName, inColumnNameLen,
            &outColumnNameLen, &outDataType[ColumbLoop], &outColumnSizePtr, &outDecimalDigitsPtr, &outNullablePtr
        );

        if(SQLResult == SQL_SUCCESS)
        {
            fwrite(&outColumnNameLen, sizeof(outColumnNameLen), 1, TargetHandle);
            fwrite(outColumnName, sizeof(char), outColumnNameLen, TargetHandle);
        }
        ColumbLoop++;
    }
    while(SQLResult == SQL_SUCCESS);

    //---------------( Get Columb Data )---
    while(SQL.DBFetch(&StatementHandle))
    {
        SQLINTEGER DataLength = 0;

        ColumbLoop = 0;
        while(ColumbLoop < outColumnCount)
        {
            SQLSMALLINT DataType = outDataType[ColumbLoop];

            if(DataType == SQL_CHAR || DataType == SQL_VARCHAR || DataType == SQL_LONGVARCHAR || DataType == SQL_TIMESTAMP)
            {
                SQLCHAR SQLBuffer[1024];

                if(SQL.DBGetData(&StatementHandle, ColumbLoop+1, SQL_C_CHAR, SQLBuffer, 1024, &DataLength))
                {
                    SQLBuffer[DataLength] = '\0';
                    if(DataLength == -1)
                    {
                        WriteNull(TargetHandle);
                    }
                    else{
                        DataLength = CharTrim(SQLBuffer, DataLength);

                        DataLength = (DataLength + 2); // To make room for the single quotes
                        fwrite(&DataLength, sizeof(DataLength), 1, TargetHandle);
                        DataLength = (DataLength - 2); // Because we only write the origional trimmed length

                        fwrite("'", 1, 1, TargetHandle); // Wrap the data in single quotes
                        fwrite(SQLBuffer, sizeof(char), DataLength, TargetHandle);
                        fwrite("'", 1, 1, TargetHandle); // Wrap the data in single quotes
                    }

                }
            }
            else if(DataType == SQL_INTEGER)
            {
                SQLINTEGER SQLBuffer = 0;
                char CharData[32];

                if(SQL.DBGetData(&StatementHandle, ColumbLoop+1, SQL_C_LONG, &SQLBuffer, 64, &DataLength))
                {
                    if(DataLength == -1)
                    {
                        WriteNull(TargetHandle);
                    }
                    else{
                        sprintf(CharData, "%d", SQLBuffer);
                        DataLength = strlen(CharData);
                        fwrite(&DataLength, sizeof(DataLength), 1, TargetHandle);
                        fwrite(CharData, sizeof(char), DataLength, TargetHandle);
                    }
                }
            }
            else if(DataType == SQL_SMALLINT)
            {
                SQLSMALLINT SQLBuffer = 0;
                char CharData[32];

                if(SQL.DBGetData(&StatementHandle, ColumbLoop+1, SQL_C_LONG, &SQLBuffer, 64, &DataLength))
                {
                    if(DataLength == -1)
                    {
                        WriteNull(TargetHandle);
                    }
                    else{
                        sprintf(CharData, "%d", SQLBuffer);
                        DataLength = strlen(CharData);
                        fwrite(&DataLength, sizeof(DataLength), 1, TargetHandle);
                        fwrite(CharData, sizeof(char), DataLength, TargetHandle);
                    }
                }
            }
            else if(DataType == SQL_REAL)
            {
                SQLFLOAT SQLBuffer = 0;
                char CharData[32];

                if(SQL.DBGetData(&StatementHandle, ColumbLoop+1, SQL_C_FLOAT, &SQLBuffer, 64, &DataLength))
                {
                    if(DataLength == -1)
                    {
                        WriteNull(TargetHandle);
                    }
                    else{
                        sprintf(CharData, "%f", SQLBuffer);
                        DataLength = strlen(CharData);
                        fwrite(&DataLength, sizeof(DataLength), 1, TargetHandle);
                        fwrite(CharData, sizeof(char), DataLength, TargetHandle);
                    }
                }
            }
            else if(DataType == SQL_DOUBLE || DataType == SQL_FLOAT)
            {
                SQLDOUBLE SQLBuffer = 0;
                char CharData[32];

                if(SQL.DBGetData(&StatementHandle, ColumbLoop+1, SQL_C_DOUBLE, &SQLBuffer, 64, &DataLength))
                {
                    if(DataLength == -1)
                    {
                        WriteNull(TargetHandle);
                    }
                    else{
                        sprintf(CharData, "%f", SQLBuffer);
                        DataLength = strlen(CharData);
                        fwrite(&DataLength, sizeof(DataLength), 1, TargetHandle);
                        fwrite(CharData, sizeof(char), DataLength, TargetHandle);
                    }
                }
            }
            else{
                printf("%d: SQL_UNKNOWN: %d\n", ColumbLoop, DataType);
            }

            ColumbLoop++;
        }
    }

    SQL.DBCloseCursor(&StatementHandle);

    SQL.DBDisconnect();

    if(TargetHandle) fclose(TargetHandle);

    return true;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

